function [] = AgingProfile(prof, batt, opt)

arguments
    prof struct
    batt struct
    opt.step_plot {mustBeNumericOrLogical} = 1
    opt.simulations struct
end

if isfield(opt,'simulations')
    n = opt.simulations.number_of_simulations;
    array = opt.simulations.array;
    legend_ = opt.simulations.legend;
    if n>0
        cmap = [linspace(.9,0,n)', linspace(.9447,.447,n)', linspace(.9741,.741,n)'];
    end
end

fig_num = 1;
step_plot = opt.step_plot;
% Plot aging profile as function of time
figure(fig_num); hold on; box on;
plot(prof.time(1:step_plot:end)/(3600*24),prof.Q_degradation_percentage(1:step_plot:end), 'LineWidth', 1.5)
if isfield(opt,'simulations'); colororder(cmap); end
ylim([0,20])
ylabel('Capacity loss (%)')
xlabel('Time (days)')


% Plot aging profile as function of Ah throughput
fig_num = fig_num+1;
figure(fig_num); hold on; box on;
if isfield(opt,'simulations'); colororder(cmap); end
plot(prof.Ah_cell(1:step_plot:end),prof.Q_degradation_percentage(1:step_plot:end), 'LineWidth', 1.5)
ylim([0,20])
ylabel('Capacity loss (%)')
xlabel('Ah thoughput (Ah)')


% Plot aging profile as function of distance
fig_num = fig_num+1;
figure(fig_num); hold on; box on;
if isfield(opt,'simulations'); colororder(cmap); end
plot(prof.distance_travelled(1:step_plot:end)/10^6,prof.Q_degradation_percentage(1:step_plot:end), 'LineWidth', 1.5)
ylim([0,20])
ylabel('Capacity loss (%)')
xlabel('Distance travelled (thousands of kms)')



%Plot battery quantities
if ~isfield(opt,'simulations')
    fig_num = fig_num + 1;
    figure(fig_num)
    t = tiledlayout(3,1);
    t.TileSpacing = 'compact';
    t.Padding = "tight";
    %xlabel(t,'Time (h)')

    % Speed
    num_tile = 1;
    ax1 = nexttile(num_tile); hold on; box on; grid on;
    speed = diff(prof.distance_travelled)./diff(prof.time);
    plot(prof.time(1:end-1)/(3600), speed*3.6,  'LineWidth', 1.5)
    ylabel("v_{veh} (km/h)")
    xticks([0:5:20,24])
    xlim([0,24])
    % Current
    num_tile = num_tile + 1;
    ax2 = nexttile(num_tile); hold on; box on; grid on;
    plot(prof.time(1:end-1)/(3600), prof.battCurr(1:end-1)/batt.numParallel, 'LineWidth', 1.5)
    ylabel('I_{cell} (A)')
    xticks([0:5:20,24])
    xlim([0,24])
    % Voltage
    % num_tile = num_tile + 1;
    % ax3 = nexttile(num_tile); hold on; box on; grid on;
    % plot(prof.time/(3600),prof.battVolt/batt.numSeries, 'LineWidth', 1.5)
    % ylabel('V_{cell} (V)')
    % xticks([0:5:20,24])
    % State of charge
    num_tile = num_tile + 1;
    ax4 = nexttile(num_tile); hold on; box on; grid on;
    plot(prof.time/(3600),prof.battSOC, 'LineWidth', 1.5)
    ylabel('SOC (-)')
    xlabel('Time (h)')
    linkaxes([ax1 ax2 ax4],'x') %ax3
    xticks([0:5:20,24])
    xlim([0,24])

    fig_num = fig_num + 1;
    figure(fig_num)
    plot(prof.time(1:end-1)/(3600), speed*3.6,  'LineWidth', 1.5)
    ylabel("v_{veh} (km/h)")
    xlabel('Time (h)')
    xticks([0:5:20,24])
    xlim([0,24])
    set(gcf, 'Position',[10 10 600 200])

    fig_num = fig_num + 1;
    figure(fig_num)
    plot(prof.time/(3600),prof.battSOC, 'LineWidth', 1.5)
    ylabel('SOC (-)')
    xlabel('Time (h)')
    xticks([0:5:20,24])
    xlim([0,24])
    set(gcf, 'Position',[10 10 600 200])
end


% figure properties
set(findall(gcf,'-property','FontSize'),'FontSize',16)
set(findall(gcf,'-property','FontName'),'FontName','Arial')

